/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.vo.MosPVo;
import jp.mosp.human.dto.MKihonDto;

public class FirstHumanAccountCardVo extends MosPVo {

	private static final long serialVersionUID = 2220781986812948427L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/firstHumanAccountCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/firstHumanAccountCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/firstHumanAccountCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ACCOUNT_MASTER;

	// 萔
	public static final int MODE_INSERT 	= 0;
	public static final int MODE_VIEW 	= 1;

	// p[^
	public static final String PRM_TXT_K_CODE     = "txtKCode"	;
	public static final String PRM_TXT_USER_NAME  = "txtUserName"	;
	public static final String PRM_PLT_OFFICE		= "pltOffice"	;
	public static final String PRM_PLT_SECTION	= "pltSection"	;
	public static final String PRM_PLT_POSITION	= "pltPosition"	;

	// tB[h
	private String txtKCode		;
	private String txtUserName	;
	private String pltOffice	;
	private String pltSection	;
	private String pltPosition	;

	// v_EXg
	public String[][] aryPltOfficeAll;
	public String[][] aryPltSectionAll;
	public String[][] aryPltPosition;

	// [h(0FVKo^A1:\)
	private int mode;

	// tB[hyѐ
	public static final String NAM_K_CODE     = CommonConst.NAM_K_CODE		;
	public static final String NAM_USER_NAME  = CommonConst.NAM_USER_NAME		;
	public static final String NAM_OFFICE		= CommonConst.NAM_OFFICE		;
	public static final String NAM_SECTION	= CommonConst.NAM_STATION		;
	public static final String NAM_POSITION	= CommonConst.NAM_POSITION1		;

	public static final int    LEN_K_CODE     = CommonConst.LEN_K_CODE;
	public static final int    LEN_USER_NAME  = CommonConst.LEN_K_NAME;

	/**
	 * RXgN^
	 */
	public FirstHumanAccountCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = 0;
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		txtKCode = "";
		txtUserName = "";
	}
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode 		= request.getParameter(PRM_TXT_K_CODE	);
		txtUserName  	= request.getParameter(PRM_TXT_USER_NAME);
		pltOffice		= request.getParameter(PRM_PLT_OFFICE	);
		pltSection		= request.getParameter(PRM_PLT_SECTION	);
		pltPosition		= request.getParameter(PRM_PLT_POSITION );
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MKihonDto dto) {
		txtKCode  	= dto.getKCode();
		txtUserName	= dto.getSimei();
		pltOffice	= dto.getJCode();
		pltSection	= dto.getSCode();
		pltPosition	= dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtKCode, NAM_K_CODE , PRM_TXT_K_CODE);
		checkRequired(txtUserName , NAM_USER_NAME , PRM_TXT_USER_NAME );
		// R[hmF
		checkCode(txtKCode, NAM_K_CODE , PRM_TXT_K_CODE);
		// 񒷊mF
		checkLength  (txtKCode    , LEN_K_CODE    , NAM_K_CODE    , PRM_TXT_K_CODE    );
		checkLength  (txtUserName , LEN_USER_NAME , NAM_USER_NAME , PRM_TXT_USER_NAME );
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtKCode() 	{ return txtKCode		; }
	public String getTxtUserName() 	{ return txtUserName	; }
	public String getPltOffice() 	{ return pltOffice		; }
	public String getPltSection()	{ return pltSection		; }
	public String getPltPosition()	{ return pltPosition	; }

	public String getEscTxtKCode() 		{ return escapeHTML(txtKCode)		; }
	public String getEscTxtUserName() 	{ return escapeHTML(txtUserName)	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
